/*
 * NIXIE_WATCH_V1A0.asm
 *
 *  Created: 14.11.2014 11:33:00
 *   Author: ArcAngelID
 */

 .include "m16Adef.inc"

 .def REG16=R16
 .def REG17=R17
 .def REG18=R18
 .def REG19=R19
 .def REG20=R20
 .def REG21=R21
 .def REG22=R22
 .def REG23=R23
 .def REG24=R24
 .def REG25=R25
 .def REG26=R26
 .def REG27=R27
 .def REG28=R28
 .def REG29=R29
 .def REG30=R30
 .def REG31=R31

 .def XregL=R26
 .def XregH=R27
 .def YregL=R28
 .def YregH=R29
 .def ZregL=R30
 .def ZregH=R31

 .dseg

 START_BYTE:                .BYTE 1

 ADC_BAT_VALUE_TEMP:        .BYTE 1  ;ADC_BAT_TEMPORARY
 ADC_VAL_FLIP:              .BYTE 1  ;ADC_FILTER_FLIP_SYNC
 ADC_BAT_CYCLES_FILTER:     .BYTE 1  ;ADC_FILTER_CYCLES
 ADC_BAT_RES_FILTER:        .BYTE 2  ;ADC_RESULT_FILTER
 ADC_BAT_RES:               .BYTE 1  ;ADC_RESULT_ON_LiION_SCAN

 I2C_CHECK_NEED_FLAG:       .BYTE 1  ;RTC_INTERRUPT_HAS_COME_ITS_TIME_TO_CHECK_RTC
 I2C_DEVICE_ERR:            .BYTE 1  ;ERR_CODE_I2C_(TYPE_MASTER)

 DATE_SET_LIMIT:            .BYTE 1  ;DATE_SET_TEMP_BUFFER 
 TIME_BUFFER:               .BYTE 1  ;TIME_DATA_BUFFER
 T_SECONDS:                 .BYTE 1  ;SECONDS_VALUE_IN_BCD
 T_MINUTES:                 .BYTE 1  ;MINUTES_VALUE_IN_BCD
 T_HOURS:                   .BYTE 1  ;HOURS_VALUE_IN_BCD
 T_ALARM:                   .BYTE 2  ;ALARM_SET_VALUE_IN_BCD
 D_DAY:                     .BYTE 1  ;DAY_NOMBER_IN_BCD
 D_YEAR:                    .BYTE 1  ;YEAR_VALUE_IN_BCD
 D_WEEK_DAY:                .BYTE 1  ;WEEK_DAY_NUMBER
 D_MONTHS:                  .BYTE 1  ;MONTH_VALUE_IN_BCD
 AGING_OFFSET:              .BYTE 1  ;CLOCK_SPEED_CLOCKING
 S_TEMPERATURE:             .BYTE 1  ;TEMPERATURE_VALUE_IN_BCD

 ON_DOT:                    .BYTE 1  ;BUFFER_SEG_PWM_FLIP
 BLINK_AUTO_OFF:            .BYTE 1  ;SET_PWM_OUTO_OFF(2SEC)_WRITE_1
 BLINK_AUTO_OFF_TIME:       .BYTE 1  ;AUTO_OFF_TIME(2SEC - 255)_IN_PWM_CLR

 BLINK_SEG:                 .BYTE 1  ;PWM_LAMP_CHOOSE_0b00001111
 BLINK_START:               .BYTE 1  ;START_PWM_BLINK_WRITE_1
 PWM_CHNG_FLAG:             .BYTE 1  ;PWM_INC_DEC_FLAG(AUTO)
 PWM_CHNG_GENERATOR:        .BYTE 1  ;PWM_FREQ_DEVIDER(AUTO)
 PWM_CHNG_BUFFER:           .BYTE 1  ;PWM_PARAMETER(AUTO)_CLR_BY_PWM_CLR

 OFF_BLOCK_FLAG:            .BYTE 1  ;PWM_AUTO_OFF(ON)
 PWM_STATUS:                .BYTE 1  ;PWM_STATUS(ON/OFF)
 SEG_PWM_PERIOD_TEMP_END:   .BYTE 1  ;PWM_OFF_FLAG(AUTO_BY_PWM_CHNG_BUFFER)
 SEG_PWM_PERIOD_TEMP_START: .BYTE 1  ;PWM_ON_FLAG(AUTO_BY_PWM_CHNG_BUFFER)
 SEG_01_PWM_PERIOD:         .BYTE 1  ;PERSONAL_PWM_WINDOW_PULSE(AUTO_BY_PWM_CHNG_BUFFER)
 SEG_02_PWM_PERIOD:         .BYTE 1  ;PERSONAL_PWM_WINDOW_PULSE(AUTO_BY_PWM_CHNG_BUFFER)
 SEG_03_PWM_PERIOD:         .BYTE 1  ;PERSONAL_PWM_WINDOW_PULSE(AUTO_BY_PWM_CHNG_BUFFER)
 SEG_04_PWM_PERIOD:         .BYTE 1  ;PERSONAL_PWM_WINDOW_PULSE(AUTO_BY_PWM_CHNG_BUFFER)

 SEG_ACT_FLAG:              .BYTE 1  ;SYMBOL_REPEATE_MONO_CHANGE_AUTO_BLOCK_FLAG
 TIME_SEGMENT:              .BYTE 1  ;PWM_SINGLE_FRAME

 SEGMENT_STEP:              .BYTE 1  ;SEGMENTS_NUMBER_CHANGE
 SEG_ELEMENT_0:             .BYTE 1  ;SEGMENT_4_DATA
 SEG_ELEMENT_1:             .BYTE 1  ;SEGMENT_3_DATA
 SEG_ELEMENT_2:             .BYTE 1  ;SEGMENT_2_DATA
 SEG_ELEMENT_3:             .BYTE 1  ;SEGMENT_1_DATA

 CENTRAL_DOT_ACTIVATE:      .BYTE 1  ;CENTRAL_DOT_ON_OFF_REG (0 - NONE,1 - ON)

 OK_FLIP:                   .BYTE 1  ;OK_FLIP_FLAG
 PUSH_TIME_FLIP:            .BYTE 1  ;PUSH_INDICATE_FLIP_FLOP
 IN_SYSTEM_CLOCK:           .BYTE 1  ;SYNC_INTERNAL_CLOCK_1Hz
 SAVE_I2C_DATA:             .BYTE 1  ;SAVE_I2C_DATA_ENABLE_FLAG

 KEY_CODE:                  .BYTE 1  ;PUSHED_KEY_CODE_IN_ASCII (IF_NO_PRESS_CODE_IS_"N")
 KEY_PUSH_DETECT:           .BYTE 1  ;KEY_PUSH\UNPUSH_DETECT_FLAG
 KEY_TIME_T_TRIGGER:        .BYTE 2  ;SCAN_&_COMPARE_CYCLE_TIME
 KEY_DUBLED:                .BYTE 1  ;CHECK_PRESS_MASK_CHANGE

 MENU_X:                    .BYTE 1  ;MENU_CHECK_POSITION_HORIZONTAL
 MENU_Y:                    .BYTE 1  ;MENU_CHECK_POSITION_VERTICAL
 MENU_Z:                    .BYTE 1  ;MENU_CHECK_POSITION_SUBMENU
 SUB_MENU_6:                .BYTE 1  ;Y-1_SUBMENU_POSITION_HORIZONTAL_SCROLL

 HALT_FLIP_BYTE:            .BYTE 2  ;BACK_TIME_TIC_TIME_TO_START_HALT
 HALT_FLIP_REG:             .BYTE 1  ;HALT_NEED_FLAG

 PWR_DOWN_BAT_LOW:          .BYTE 1

 END_BYTE:                  .BYTE 1

 .eseg
 .cseg

 .org 0x000 JMP RESET;PROGRAM_START
 .org 0x002 JMP INT_0;RTC_INT
 .org 0x004 JMP RESET;INT_1
 .org 0x006 JMP TIMER2_COMP;DISPLAY_DRV
 .org 0x008 JMP TIMER2_OVF
 .org 0x00A JMP TIMER1_CAPT
 .org 0x00C JMP TIMER1_COMP_A;1_HZ_TIMER
 .org 0x00E JMP TIMER1_COMP_B
 .org 0x010 JMP TIMER1_OVF
 .org 0x012 JMP TIMER0_OVF
 .org 0x014 JMP SPI_STC
 .org 0x016 JMP USART_RX
 .org 0x018 JMP USART_UDRE
 .org 0x01A JMP USART_TX
 .org 0x01C JMP ADC_10_BIT
 .org 0x01E JMP EE_READY
 .org 0x020 JMP ANALOG_COMP
 .org 0x022 JMP TWI
 .org 0x024 JMP RESET;INT_2;USB_INT
 .org 0x026 JMP TIMER0_COMP;INVERTOR_PWM
 .org 0x028 JMP SPM_READY

;RESET:
;INT_0:
;INT_1:
;TIMER2_COMP:;DISPLAY_DRV
TIMER2_OVF:
TIMER1_CAPT:
;TIMER1_COMP_A:
TIMER1_COMP_B:
TIMER1_OVF:
TIMER0_OVF:
SPI_STC:
USART_RX:
USART_UDRE:
USART_TX:
;ADC_10_BIT:
EE_READY:
ANALOG_COMP:
TWI:
;INT_2:
TIMER0_COMP:
SPM_READY:

RETI

RESET:
 LDI REG16,LOW(RAMEND)
  OUT SPL,REG16
   LDI REG16,HIGH(RAMEND)
    OUT SPH,REG16

PROGRAM_START:
 CALL PORTS_INIT
  CALL CLR_MEM
   CALL I2C_DS3231_START_INIT
    CALL INTERRUPT_INIT
     CALL TIMER_INIT_2
      LDI REG16,1
       STS MENU_Z,REG16
        CLR REG21
         CLR REG16
          STS PWR_DOWN_BAT_LOW,REG16
           CALL CLR_PWM
            LDI REG16,'P'
             STS KEY_PUSH_DETECT,REG16
              CALL I2C_TIME_PROC_READ
               CALL ADC_INIT

SEI

MAIN:
 LDS REG16,PWR_DOWN_BAT_LOW
  CPI REG16,1
   BREQ NO_KEY
    CALL KEYBOARD_PORTx

NO_KEY:
 CALL CHK_MENU
  LDS REG16,OFF_BLOCK_FLAG
   TST REG16
    BRNE NO_F_HALT
     CALL HALT_FUNCTION

NO_F_HALT:
 CALL ADC_BAT_FILTER_CHK
  LDS REG16,ADC_BAT_RES
   ;TST REG16
   CPI REG16,1
    BRSH PWR_DOWN_NO
     CALL PWM_OFF

PWR_DOWN_NO:

JMP MAIN
;------------------------------------------
;ֲ ²  
;------------------------------------------
HALT_FUNCTION:
 LDS REG16,KEY_CODE
  CPI REG16,'N'
   BRNE NEED_ON
    LDS REG16,HALT_FLIP_REG
     CPI REG16,10
      BRNE NO_HALT

HALT:
 ;IN REG16,PINB
  ;SBRC REG16,2;--------------
   ;JMP CHARGE;---------------
    CALL DEINIT_ALL
     SLEEP

RET

NEED_ON:
 CLR REG16
  STS HALT_FLIP_REG,REG16
   LDS REG16,PWM_STATUS
    TST REG16
     BRNE NO_HALT
      CALL PWM_ON

NO_HALT:

RET

CHARGE:
 CLR REG16
  STS HALT_FLIP_REG,REG16
   CALL PWM_ON

RET
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;--------------------------------------MENU_MODULES--------------------------
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------

;-----------------------------------------------
;ֲ   
;-----------------------------------------------
CHK_MENU: ;ֲ   ²  ˲ 
 LDS REG16,MENU_X
  CPI REG16,0
   BRNE MENU_DATE
    CALL TIME_MENU_X0_Y_Z ;ղ   
     JMP DATA_REFRESH_ENABLE

MENU_DATE:
 CPI REG16,1
  BRNE MENU_TEMP
   CALL DATE_MENU_X1_Y_Z ;ղ   
    JMP DATA_REFRESH_ENABLE

MENU_TEMP:
 CPI REG16,2
  BRNE DATA_REFRESH_ENABLE
   CALL TEMP_MENU_X2_Y_Z ;ղ   

DATA_REFRESH_ENABLE: ;²  ̲  
 LDS REG16,MENU_Y
  TST REG16
   BRNE MENU_IS_SETTING
    CALL CHK_RELOAD_NEED

MENU_IS_SETTING:
 RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;----CHK_RELOAD_PROC----
;----------------------------------------------
CHK_RELOAD_NEED:
 LDS REG16,I2C_CHECK_NEED_FLAG
  TST REG16
   BREQ RELOAD_NO_NEED
    CALL I2C_TIME_PROC_READ
     CLR REG16
      STS I2C_CHECK_NEED_FLAG,REG16 

RELOAD_NO_NEED:
 RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------------------------------
;ֲ ² 
;-----------------------------------------------
TIME_MENU_X0_Y_Z: ;²   
 LDS REG16,MENU_Z
  CPI REG16,1
   BRNE X0_Z0

X0_Z1: ;² +
 LDS XregL,T_MINUTES
  LDS XregH,T_HOURS
   JMP X0_IND

X0_Z0: ;² +
 LDS XregL,T_SECONDS
  LDS XregH,T_MINUTES

X0_IND:
 CALL DISPLAY_SEGMENT_DECODER

RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------------------------------
;ֲ ² 
;-----------------------------------------------
DATE_MENU_X1_Y_Z: ;²   
 LDS REG16,MENU_Z
  CPI REG16,1
   BREQ X1_Z1

X1_Z0: ;² ̲+в
 LDS XregL,D_YEAR
  LDS XregH,D_MONTHS
   JMP X1_IND

X1_Z1: ;² ()+̲
 LDS XregL,D_MONTHS
  LDS XregH,D_DAY

X1_IND:
 CALL DISPLAY_SEGMENT_DECODER

RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------------------------------
;ֲ ² 
;-----------------------------------------------
TEMP_MENU_X2_Y_Z: ;²   
 LDS REG16,MENU_Y
  TST REG16
   BREQ LOAD_TEMPERATURE 
    LDS REG16,AGING_OFFSET ; Ҳ 
     JMP TEM_AGNG

LOAD_TEMPERATURE:
 LDS REG16,S_TEMPERATURE ; 

TEM_AGNG:
 SBRS REG16,7
  JMP T_SIGN_CHECK_0
   LDI REG17,1
    STS CENTRAL_DOT_ACTIVATE,REG17
     JMP T_SIGN_CHECK_1

T_SIGN_CHECK_0:
 CLR REG17
  STS CENTRAL_DOT_ACTIVATE,REG17

T_SIGN_CHECK_1:
 ANDI REG16,0b01111111
  MOV REG17,REG16
   SUBI REG16,100
    BRMI NO_HUNDRED
     LDI REG18,9
      LDI XL,9
       JMP CONVERT_OUT

NO_HUNDRED:
 MOV REG16,REG17
  CLR XL

SUBSTRACT_TEN:
 SUBI REG16,10
  BRMI CONVERT_OUT
   INC XL
    MOV REG17,REG16
     JMP SUBSTRACT_TEN

CONVERT_OUT: ;² 
 LDS REG16,MENU_Y
  TST REG16
   BRNE AGNG_OUTPUT
    LDI REG16,1
     STS BLINK_AUTO_OFF,REG16
      STS SEG_ELEMENT_0,REG17
       STS SEG_ELEMENT_1,XL
        LDS REG16,ADC_BAT_RES ;²  ů
         CPI REG16,99
          BRSH BAT_MAX
           CPI REG16,1
            BRLO BAT_ZERO
             JMP CHK_BAT_VALUE

BAT_MAX:
 LDI REG16,9
  JMP BAT_OUTPUT

BAT_ZERO:
 CLR REG16
  CLR REG17
   JMP BAT_OUTPUT

CHK_BAT_VALUE:
 CLR REG17

BAT_V_C_0: ;ֲ  ů
 MOV REG18,REG16
  SUBI REG16,10
   BRMI TENS_VALUE
    INC REG17
     JMP BAT_V_C_0

TENS_VALUE:
 STS SEG_ELEMENT_3,REG17
  CLR REG17
   MOV REG16,REG18

BAT_V_C_1:
 DEC REG16
  BRMI VALUE_ONE
   INC REG17
    JMP BAT_V_C_1

VALUE_ONE:
 STS SEG_ELEMENT_2,REG17
  JMP T_TEST_AGNG

BAT_OUTPUT:
 STS SEG_ELEMENT_2,REG16
  STS SEG_ELEMENT_3,REG16
   JMP T_TEST_AGNG

AGNG_OUTPUT: ;² Ҳ 
 LDI REG16,1
  STS BLINK_START,REG16
   LDI REG16,0b00001100
    STS BLINK_SEG,REG16
     STS SEG_ELEMENT_2,REG17
      STS SEG_ELEMENT_3,XL
       LDI REG16,0x00
        STS SEG_ELEMENT_0,REG16
         STS SEG_ELEMENT_1,REG16

T_TEST_AGNG:
 CALL INTERNAL_LOGIC
  LDS REG16,SAVE_I2C_DATA
   TST REG16
    BREQ TEMP_OUT
     CLR REG16
      STS SAVE_I2C_DATA,REG16
       CALL I2C_SAVE_AGING_TO_DS3231

TEMP_OUT:
 RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;--------------------------------------FUNCTIONAL_MODULES--------------------
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------

;-----------------------------------------------
;ֲ   ů
;-----------------------------------------------
ADC_BAT_FILTER_CHK: ;Բֲ  ů
 LDS REG16,ADC_VAL_FLIP
  TST REG16
   BREQ ADC_BAT_FILTER_OUT
    LDS REG16,ADC_BAT_CYCLES_FILTER
     TST REG16
      BREQ START_FILTER
       LDS REG16,ADC_BAT_CYCLES_FILTER
        DEC REG16
         STS ADC_BAT_CYCLES_FILTER,REG16
          LDS REG16,ADC_BAT_VALUE_TEMP
           CLR REG17
            LDS REG18,ADC_BAT_RES_FILTER
             LDS REG19,ADC_BAT_RES_FILTER+1
              ADD REG18,REG16
               ADC REG19,REG17
                STS ADC_BAT_RES_FILTER,REG18
                 STS ADC_BAT_RES_FILTER+1,REG19
                  JMP CLR_FLIP

START_FILTER:
 LDI REG18,7
  LDS REG16,ADC_BAT_RES_FILTER
   LDS REG17,ADC_BAT_RES_FILTER+1

FILTER_LOOP:
 ROR REG17
  ROR REG16
   CLC
    DEC REG18
     BRNE FILTER_LOOP
      MOV XregL,REG16
       CLR XregH
        CLR YregH
         LDI YregL,10
          CALL MULTI
           CLR YregH
            LDI YregL,16
             CALL DEVIDE
              STS ADC_BAT_RES,XregL
               CLR REG16
                STS ADC_BAT_RES_FILTER,REG16
                 STS ADC_BAT_RES_FILTER+1,REG16
                  LDI REG16,128
                   STS ADC_BAT_CYCLES_FILTER,REG16

CLR_FLIP:
 CLR REG16
  STS ADC_VAL_FLIP,REG16
   CALL ADC_INIT

ADC_BAT_FILTER_OUT:
 RET
;------PROC_END---------
;-----------------------

;--------------------------------------------------------------
;--------------------------------------------------------------
;----------------------16- ----------------------
;--------------------------------------------------------------
;--------------------------------------------------------------

DEVIDE:        ; 
CLR R16
CLR R17
LDI R19,1      ;  r23 - 
MINUS:         ;    
CP XL,YL       ;     
CPC XH,YH      ;     
BRLO EXIT      ;   ,    
SUB XL,YL      ;     ( )
SBC XH,YH      ;  
CLR R18
ADD R16,R19    ;   
ADC R17,R18
JMP MINUS     ;   
EXIT:          ;   
MOV XL,R16
MOV XH,R17
RET

;--------------------------------------------------------------
;---------------------------------------------------------
;----------------------16- ----------------------
;--------------------------------------------------------------
;--------------------------------------------------------------

;--------------------------------------------------------------
;--------------------------------------------------------------
;---------------------16- ----------------------
;--------------------------------------------------------------
;--------------------------------------------------------------


MULTI:
CLR R18        ; 
MUL XL,YL      ; 
MOV R16,R0     ; r0    mul
MOV R17,R1     ; r1    mul
MUL XH,YL      ;   
ADD R17,R0     ; r0    mul
ADC R18,R1     ; r1    mul
MUL XL,YH      ;   
ADD R17,R0     ; r0    mul
ADC R18,R1     ; r1    mul
MUL XH,YH      ;   
ADD R18,R0     ;4-     ,     r01
MOV XL,R16
MOV XH,R17
RET

;--------------------------------------------------------------
;---------------------------------------------------------
;---------------------16- ----------------------
;--------------------------------------------------------------

;-----------------------------------------------
;ֲ ̲   Ҳ
;-----------------------------------------------
SEG_DOTS_SET_INDICATE:
 LDS REG16,MENU_Y
  TST REG16
   BREQ TMO2
    CLR REG16
     STS BLINK_AUTO_OFF,REG16
      LDS REG16,MENU_Z
       TST REG16
        BRNE TMZ0
         LDS REG16,SUB_MENU_6
          CPI REG16,0
           BRNE DOT_1
            CALL ON_0_DOT
             JMP TMO2

DOT_1:
 CPI REG16,1
  BRNE DOT_2
   CALL ON_1_DOT
    JMP TMO2

DOT_2:
 CPI REG16,2
  BRNE DOT_3
   CALL ON_2_DOT
    JMP TMO2

DOT_3:
 CPI REG16,3
  BRNE TMO2
   CALL ON_3_DOT
    JMP TMO2

TMZ0:
 LDS REG16,SUB_MENU_6
  CPI REG16,2
   BRNE NDOT_1
    CALL ON_0_DOT
     JMP TMO2

NDOT_1:
 CPI REG16,3
  BRNE NDOT_2
   CALL ON_1_DOT
    JMP TMO2

NDOT_2:
 CPI REG16,4
  BRNE NDOT_3
   CALL ON_2_DOT
    JMP TMO2

NDOT_3:
 CPI REG16,5
  BRNE TMO2
   CALL ON_3_DOT

TMO2:

RET

ON_0_DOT:
 LDS REG16,ON_DOT
  CPI REG16,1
   BREQ ON_0_DOT_OUT
    LDI REG16,1
     STS ON_DOT,REG16
      CALL CLR_PWM
       LDI REG16,1
        STS BLINK_START,REG16
         LDI REG16,0b00000001
          STS BLINK_SEG,REG16

ON_0_DOT_OUT:

RET

ON_1_DOT:
 LDS REG16,ON_DOT
  CPI REG16,2
   BREQ ON_1_DOT_OUT
    LDI REG16,2
     STS ON_DOT,REG16
      CALL CLR_PWM
       LDI REG16,1
        STS BLINK_START,REG16
         LDI REG16,0b00000010
          STS BLINK_SEG,REG16

ON_1_DOT_OUT:

RET

ON_2_DOT:
 LDS REG16,ON_DOT
  CPI REG16,3
   BREQ ON_2_DOT_OUT
    LDI REG16,3
     STS ON_DOT,REG16
      CALL CLR_PWM
       LDI REG16,1
        STS BLINK_START,REG16
         LDI REG16,0b00000100
          STS BLINK_SEG,REG16

ON_2_DOT_OUT:

RET

ON_3_DOT:
 LDS REG16,ON_DOT
  CPI REG16,4
   BREQ ON_3_DOT_OUT
    LDI REG16,4
     STS ON_DOT,REG16
      CALL CLR_PWM
       LDI REG16,1
        STS BLINK_START,REG16
         LDI REG16,0b00001000
          STS BLINK_SEG,REG16

ON_3_DOT_OUT:

RET

ON_ALL_DOT: ; Ѳ Ҳ
 CLR REG16
  STS KEY_CODE,REG16
   CALL CLR_PWM
    LDI REG16,0b00001111
     STS BLINK_SEG,REG16
      LDI REG16,1
       STS BLINK_AUTO_OFF,REG16
        STS BLINK_START,REG16

RET
;----------------------
CLR_KC_R_DDOTS: ;   +   Ҳ  2
 CLR REG16
  STS KEY_CODE,REG16
   CALL CLR_PWM
    LDI REG16,0b00000011
     STS BLINK_SEG,REG16
      LDI REG16,1
       STS BLINK_AUTO_OFF,REG16
        STS BLINK_START,REG16

RET
;----------------------
CLR_KC_L_DDOTS: ;   +   ˲ Ҳ  2
 CLR REG16
  STS KEY_CODE,REG16
   CALL CLR_PWM
    LDI REG16,0b00001100
     STS BLINK_SEG,REG16
      LDI REG16,1
       STS BLINK_AUTO_OFF,REG16
        STS BLINK_START,REG16

RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------------------------------
;ֲ  ò ֲ ̲  
;-----------------------------------------------
MENU_ERR_CLR: ; -˲  +  
 CLR REG16
  STS MENU_X,REG16
   STS MENU_Y,REG16
    STS MENU_Z,REG16
     RET

TIME_MENU_LOGIC:
 JMP TIME_MENU_LOGIC_L ;   ò ʲ 

DATE_MENU_LOGIC:
 JMP DATE_MENU_LOGIC_L ;   ò ʲ 

TEMPERATURE_MENU_LOGIC:
 JMP TEMPERATURE_MENU_LOGIC_L ;   ò ʲ 

INTERNAL_LOGIC: ; ֲ ò  ̲ Ѳ +  ò 
 LDS REG16,MENU_X
  CPI REG16,0
   BREQ TIME_MENU_LOGIC
    CPI REG16,1
     BREQ DATE_MENU_LOGIC
      CPI REG16,2
       BREQ TEMPERATURE_MENU_LOGIC
        CPI REG16,3
         BRSH MENU_ERR_CLR

;-----------------------------------------------
;ֲ  ò     Y
;-----------------------------------------------
TIME_MENU_LOGIC_L: ; , ² в ˲ 0, 1, 2 
 LDS REG16,MENU_Y
  CPI REG16,0
   BREQ TIME_MENU_LOGIC_STAGE_Y0_L
    CPI REG16,1
     BREQ TIME_MENU_LOGIC_STAGE_Y1_L
      CPI REG16,2
       BREQ TIME_MENU_LOGIC_STAGE_Y2_L
        CLR REG16
         STS MENU_Y,REG16
          RET

TIME_MENU_LOGIC_STAGE_Y0_L: ; , в 0,   , ̲  ,     в - 1
 CALL LOGIC_VECTOR_SUPERVISOR_LEVEL_Y0
  RET

TIME_MENU_LOGIC_STAGE_Y1_L: ;в   X0,-1,Z0
 CALL LOGIC_VECTOR_SUPERVISOR_LEVEL_Y1
  RET

;-----------------------------------------------
;ֲ  ò    "X"  вͲ "2"
;-----------------------------------------------
TIME_MENU_LOGIC_STAGE_Y2_L:
 LDS REG16,KEY_CODE
  CPI REG16,'R'
   BRNE TMLSY2L_L
    LDS REG16,SUB_MENU_6
     CPI REG16,0
      BRNE INC_SEC_TEN
       JMP INC_SET_SEC_ONE

INC_SEC_TEN:
 CPI REG16,1
  BRNE INC_MIN_ONE
   JMP INC_SET_SEC_TEN
      
INC_MIN_ONE:
 CPI REG16,2
  BRNE INC_MIN_TEN
   JMP INC_SET_MIN_ONE

INC_MIN_TEN:
 CPI REG16,3
  BRNE INC_HOUR_ONE
   JMP INC_SET_MIN_TEN

INC_HOUR_ONE:
 CPI REG16,4
  BRNE INC_HOUR_TEN
   JMP INC_SET_HOUR_ONE

INC_HOUR_TEN:
 CPI REG16,5
  BRNE TIME_INC_ERR
   JMP INC_SET_HOUR_TEN
    RET

TIME_INC_ERR:
 RET

TMLSY2L_L:
 LDS REG16,KEY_CODE
  CPI REG16,'L'
   BRNE TMLSY2L_C
    LDS REG16,SUB_MENU_6
     CPI REG16,0
      BRNE DEC_SEC_TEN
       JMP DEC_SET_SEC_ONE

DEC_SEC_TEN:
 CPI REG16,1
  BRNE DEC_MIN_ONE
   JMP DEC_SET_SEC_TEN
      
DEC_MIN_ONE:
 CPI REG16,2
  BRNE DEC_MIN_TEN
   JMP DEC_SET_MIN_ONE

DEC_MIN_TEN:
 CPI REG16,3
  BRNE DEC_HOUR_ONE
   JMP DEC_SET_MIN_TEN

DEC_HOUR_ONE:
 CPI REG16,4
  BRNE DEC_HOUR_TEN
   JMP DEC_SET_HOUR_ONE

DEC_HOUR_TEN:
 CPI REG16,5
  BRNE TIME_DEC_ERR
   JMP DEC_SET_HOUR_TEN
    RET

TIME_DEC_ERR:
 RET

TMLSY2L_C:
 LDS REG16,KEY_CODE
  CPI REG16,'C'
   BRNE TMLSY2L_OUT
    LDI REG16,1
     STS MENU_Y,REG16
      CLR REG16
       STS KEY_CODE,REG16

TMLSY2L_OUT:
 RET

CLT_KEY:
 CLR REG16
  STS KEY_CODE,REG16
   RET

;-----------------------------------------------
;ֲ  ò    "X"  вͲ "0"
;-----------------------------------------------
LOGIC_VECTOR_SUPERVISOR_LEVEL_Y0:
 LDI REG16,1
  STS BLINK_AUTO_OFF,REG16
   LDS REG16,KEY_CODE
    CPI REG16,'R'
     BRNE CHK_UN_L
      LDS REG16,MENU_Z
       TST REG16
        BREQ SUB_MENU_Z0_R

SUB_MENU_Z1_R:
 CLR REG16
  STS MENU_Z,REG16
   CALL CLR_KC_R_DDOTS
    CALL HOLD_CLR
     RET

SUB_MENU_Z0_R:
 LDS REG16,MENU_X
  TST REG16
   BREQ IF_X0_R
    CALL RIGHT_X_SLIDE
     LDI REG16,1
      STS MENU_Z,REG16
       CALL HOLD_CLR
        RET

IF_X0_R:
 CALL CLR_KC_R_DDOTS
  CALL HOLD_CLR
   RET

CHK_UN_L:
 CPI REG16,'L'
  BRNE CHK_UN_C
   LDS REG16,MENU_Z
    TST REG16
     BREQ SUB_MENU_Z0_L

SUB_MENU_Z1_L:
 LDS REG16,MENU_X
  CPI REG16,1
   BREQ IF_X1_Z1
    CPI REG16,2
     BREQ IF_X2_Z0
      CALL LEFT_X_SLIDE
       CLR REG16
        STS MENU_Z,REG16
         CALL HOLD_CLR
          RET

IF_X2_Z0:
 CALL ON_ALL_DOT
  CALL HOLD_CLR
   RET

IF_X1_Z1:
 LDI REG16,2
  STS MENU_X,REG16
   CLR REG16
    STS MENU_Z,REG16
     CALL ON_ALL_DOT
      CALL HOLD_CLR
       RET

SUB_MENU_Z0_L:
 LDS REG16,MENU_X
  CPI REG16,2
   BREQ IF_X2_L
    LDI REG16,1
     STS MENU_Z,REG16
      CALL CLR_KC_L_DDOTS
       CALL HOLD_CLR
        RET

IF_X2_L:
 CALL ON_ALL_DOT
  CALL HOLD_CLR
   RET

CHK_UN_C:
 CALL OK_HOLD
  LDS REG16,SAVE_I2C_DATA
   TST REG16
    BREQ SAVE_FLAG_NONE_1
     LDS REG16,OFF_BLOCK_FLAG
      COM REG16
       ANDI REG16,0b00000001
        STS OFF_BLOCK_FLAG,REG16
         CLR REG16
          STS SAVE_I2C_DATA,REG16

SAVE_FLAG_NONE_1:
 LDS REG16,KEY_CODE
  CPI REG16,'N'
   BRNE SAVE_FLAG_NONE_OUT_1
    LDS REG16,OK_FLIP
     TST REG16
      BREQ SAVE_FLAG_NONE_OUT_1
       CLR REG16
        STS OK_FLIP,REG16
         CALL VERTICAL_Y_SLIDE_D
          LDS REG16,MENU_Z
           CPI REG16,1
            BREQ UP_FROM_Z1
             TST REG16
              BREQ UP_FROM_Z0

UP_FROM_Z0:
 CLR REG16
  STS SUB_MENU_6,REG16
   JMP SAVE_FLAG_NONE_OUT_1

UP_FROM_Z1:
 LDI REG16,2
  STS SUB_MENU_6,REG16

SAVE_FLAG_NONE_OUT_1:
 RET

;-----------------------------------------------
;ֲ  ò    "X"  вͲ "1"
;-----------------------------------------------
LOGIC_VECTOR_SUPERVISOR_LEVEL_Y1:
 LDS REG16,MENU_Z
  CPI REG16,1
   BREQ LEVEL_Y1_Z1

LEVEL_Y1_Z0:
 LDS REG16,KEY_CODE
  CPI REG16,'L'
   BRNE LEVEL_Y1_Z0_R
    LDS REG16,SUB_MENU_6
     CPI REG16,3
      BREQ Z0_TOP
       INC REG16
        STS SUB_MENU_6,REG16
         CLR REG16
          STS KEY_CODE,REG16
           CALL HOLD_CLR
            RET

Z0_TOP:
 LDI REG16,1
  STS MENU_Z,REG16
   CLR REG16
    STS KEY_CODE,REG16
     CALL HOLD_CLR
      RET

LEVEL_Y1_Z0_R:
 LDS REG16,KEY_CODE
  CPI REG16,'R'
   BRNE LEVEL_Y1_Z_C
    LDS REG16,SUB_MENU_6
     TST REG16
      BREQ LEVEL_Y1_Z_LR_NONE
       DEC REG16
        STS SUB_MENU_6,REG16
         CLR REG16
          STS KEY_CODE,REG16
           CALL HOLD_CLR
            RET

LEVEL_Y1_Z_LR_NONE:
 CLR REG16
  STS KEY_CODE,REG16
   RET

LEVEL_Y1_Z1:
 LDS REG16,KEY_CODE
  CPI REG16,'L'
   BRNE LEVEL_Y1_Z1_R
    LDS REG16,SUB_MENU_6
     CPI REG16,5
      BREQ LEVEL_Y1_Z_LR_NONE
       INC REG16
        STS SUB_MENU_6,REG16
         CLR REG16
          STS KEY_CODE,REG16
           CALL HOLD_CLR
            RET

LEVEL_Y1_Z1_R:
 LDS REG16,KEY_CODE
  CPI REG16,'R'
   BRNE LEVEL_Y1_Z_C
    LDS REG16,SUB_MENU_6
     CPI REG16,2
      BREQ Z1_BOTTOM
       DEC REG16
        STS SUB_MENU_6,REG16
         CLR REG16
          STS KEY_CODE,REG16
           CALL HOLD_CLR
            RET

Z1_BOTTOM:
 CLR REG16
  STS MENU_Z,REG16
   STS KEY_CODE,REG16
    CALL HOLD_CLR
     RET

LEVEL_Y1_Z_C:
 CALL OK_HOLD
  LDS REG16,SAVE_I2C_DATA
   TST REG16
    BREQ SAVE_FLAG_NONE
     LDS REG16,MENU_X
      TST REG16
       BREQ SAVE_TIME_TO_DS3231
        CALL I2C_SAVE_DATE_TO_DS3231
         CLR REG16
          STS SAVE_I2C_DATA,REG16
           JMP SAVE_FLAG_NONE

SAVE_TIME_TO_DS3231:
 CALL I2C_SAVE_TIME_TO_DS3231
  CLR REG16
   STS SAVE_I2C_DATA,REG16

SAVE_FLAG_NONE:
 LDS REG16,KEY_CODE
  CPI REG16,'N'
   BRNE SAVE_FLAG_NONE_OUT
    LDS REG16,OK_FLIP
     TST REG16
      BREQ SAVE_FLAG_NONE_OUT
       CLR REG16
        STS OK_FLIP,REG16
         LDI REG16,2
          STS MENU_Y,REG16

SAVE_FLAG_NONE_OUT:

RET

;-----------------------------------------------
;ֲ ̲  
;-----------------------------------------------
LEFT_X_SLIDE: ; -˲
 LDS REG16,MENU_X
  CPI REG16,2
   BRSH LEFT_X_SLIDE_OUT
    INC REG16
     STS MENU_X,REG16

LEFT_X_SLIDE_OUT:
 CALL CLR_KC_R_DDOTS
  CLR REG16
   STS KEY_CODE,REG16
    RET
;----------------------
RIGHT_X_SLIDE: ; -˲
 LDS REG16,MENU_X
  TST REG16
   BREQ RIGHT_X_SLIDE_OUT
    DEC REG16
     STS MENU_X,REG16

RIGHT_X_SLIDE_OUT:
 CALL CLR_KC_L_DDOTS
  CLR REG16
   STS KEY_CODE,REG16
    RET
;----------------------
VERTICAL_Y_SLIDE_D: ; -˲
 LDS REG16,MENU_Y
  CPI REG16,2
   BRSH Y_SLIDE_D_OUT
    INC REG16
     STS MENU_Y,REG16

Y_SLIDE_D_OUT:
 CLR REG16
  STS KEY_CODE,REG16
   RET
;----------------------
HOLD_CLR: ;ֲ  Ѳ   "" ² 
 CALL TIMER_DEINIT_1
  CLR REG16
   STS PUSH_TIME_FLIP,REG16
    STS IN_SYSTEM_CLOCK,REG16
     RET
;----------------------
OK_HOLD: ;ֲ  ί  ""
 LDS REG16,KEY_CODE
  CPI REG16,'C'
   BRNE HOLD_CLR
    LDS REG16,PUSH_TIME_FLIP
     TST REG16
      BREQ START_1HZ_TIMER
       LDS REG16,IN_SYSTEM_CLOCK
        CPI REG16,1
         BRNE ON_HOLD_OUT
          CLR REG16
           STS MENU_Y,REG16
            STS KEY_CODE,REG16
             STS OK_FLIP,REG16
              LDI REG16,1
               STS SAVE_I2C_DATA,REG16
                CALL HOLD_CLR
                 JMP ON_HOLD_OUT

START_1HZ_TIMER:
 CLR REG16
  STS IN_SYSTEM_CLOCK,REG16
   CALL TIMER_INIT_1
    LDI REG16,1
     STS PUSH_TIME_FLIP,REG16
      STS OK_FLIP,REG16

ON_HOLD_OUT:
 RET

;-----------------------------------------------
;ֲ     
;-----------------------------------------------
INC_SET_SEC_ONE:
 LDS REG16,T_SECONDS
  MOV REG17,REG16
   CALL INC_9_T
    STS T_SECONDS,REG16
     JMP CLT_KEY

INC_SET_SEC_TEN:
 LDS REG16,T_SECONDS
  MOV REG17,REG16
   CALL INC_5_T
    STS T_SECONDS,REG16
     JMP CLT_KEY

INC_SET_MIN_ONE:
 LDS REG16,T_MINUTES
  MOV REG17,REG16
   CALL INC_9_T
    STS T_MINUTES,REG16
     JMP CLT_KEY

INC_SET_MIN_TEN:
 LDS REG16,T_MINUTES
  MOV REG17,REG16
   CALL INC_5_T
    STS T_MINUTES,REG16
     JMP CLT_KEY

INC_SET_HOUR_ONE:
 LDS REG16,T_HOURS
  STS TIME_BUFFER,REG16
   CALL INC_3_9_T
    LDS REG16,TIME_BUFFER
     STS T_HOURS,REG16
      JMP CLT_KEY

INC_SET_HOUR_TEN:
 LDS REG16,T_HOURS
  STS TIME_BUFFER,REG16
   CALL INC_2_T
    LDS REG16,TIME_BUFFER
     STS T_HOURS,REG16
      JMP CLT_KEY

DEC_SET_SEC_ONE:
 LDS REG16,T_SECONDS
  MOV REG17,REG16
   CALL DEC_9_T
    STS T_SECONDS,REG16
     JMP CLT_KEY

DEC_SET_SEC_TEN:
 LDS REG16,T_SECONDS
  MOV REG17,REG16
   CALL DEC_5_T
    STS T_SECONDS,REG16
     JMP CLT_KEY

DEC_SET_MIN_ONE:
 LDS REG16,T_MINUTES
  MOV REG17,REG16
   CALL DEC_9_T
    STS T_MINUTES,REG16
     JMP CLT_KEY

DEC_SET_MIN_TEN:
 LDS REG16,T_MINUTES
  MOV REG17,REG16
   CALL DEC_5_T
    STS T_MINUTES,REG16
     JMP CLT_KEY

DEC_SET_HOUR_ONE:
 LDS REG16,T_HOURS
  STS TIME_BUFFER,REG16
   CALL DEC_3_9_T
    LDS REG16,TIME_BUFFER
     STS T_HOURS,REG16
      JMP CLT_KEY

DEC_SET_HOUR_TEN:
 LDS REG16,T_HOURS
  STS TIME_BUFFER,REG16
   CALL DEC_2_T
    LDS REG16,TIME_BUFFER
     STS T_HOURS,REG16
      JMP CLT_KEY

INC_9_T:
 ANDI REG16,0b00001111
  CPI REG16,0x09
   BREQ OVERLAP_INC_SET_SEC_ONE
    INC REG16
     JMP INC_SET_SEC_ONE_SAVE

OVERLAP_INC_SET_SEC_ONE:
 CLR REG16

INC_SET_SEC_ONE_SAVE:
 ANDI REG17,0b11110000
  ADD REG16,REG17
   RET

INC_5_T:
 ANDI REG16,0b11110000
  CPI REG16,0x50
   BREQ OVERLAP_INC_SET_SEC_TEN
    SUBI REG16,-16
     JMP INC_SET_SEC_TEN_SAVE

OVERLAP_INC_SET_SEC_TEN:
 CLR REG16

INC_SET_SEC_TEN_SAVE:
 ANDI REG17,0b00001111
  ADD REG16,REG17
   RET

INC_3_9_T:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b11110000
   CPI REG16,0x20
    BRLO HOURS_MAX_INC_X9
     LDS REG16,TIME_BUFFER
      ANDI REG16,0b00001111
       CPI REG16,0x03
        BREQ OVERLAP_INC_SET_HOUR_ONE
         INC REG16
          JMP INC_SET_HOUR_ONE_SAVE

HOURS_MAX_INC_X9:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b00001111
   CPI REG16,0x09
    BREQ OVERLAP_INC_SET_HOUR_ONE
     INC REG16
      JMP INC_SET_HOUR_ONE_SAVE

OVERLAP_INC_SET_HOUR_ONE:
 CLR REG16

INC_SET_HOUR_ONE_SAVE:
 LDS REG17,TIME_BUFFER
  ANDI REG17,0b11110000
   ADD REG16,REG17
    STS TIME_BUFFER,REG16
     RET

INC_2_T:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b11110000
   CPI REG16,0x20
    BRSH OVERLAP_INC_SET_HOUR_TEN
     SUBI REG16,-16
      LDS REG17,TIME_BUFFER
       ANDI REG17,0b11110000
        CPI REG17,0x10
         BREQ HOURS_INC_CLR
          JMP INC_SET_HOUR_TEN_SAVE

HOURS_INC_CLR:
 LDS REG17,TIME_BUFFER
  ANDI REG17,0b00001111
   CPI REG17,0x04
    BRSH SET_MAX_23_TOP
     JMP INC_SET_HOUR_TEN_SAVE

OVERLAP_INC_SET_HOUR_TEN:
 CLR REG16

INC_SET_HOUR_TEN_SAVE:
 LDS REG17,TIME_BUFFER
  ANDI REG17,0b00001111
   ADD REG16,REG17
    STS TIME_BUFFER,REG16
     JMP CLT_KEY

SET_MAX_23_TOP:
 LDI REG16,0x23
  STS TIME_BUFFER,REG16
   RET

DEC_9_T:
 ANDI REG16,0b00001111
  TST REG16
   BREQ OVERLAP_DEC_SET_SEC_ONE
    DEC REG16
     JMP DEC_SET_SEC_ONE_SAVE

OVERLAP_DEC_SET_SEC_ONE:
 LDI REG16,0x09

DEC_SET_SEC_ONE_SAVE:
 ANDI REG17,0b11110000
  ADD REG16,REG17
   RET

DEC_5_T:
 ANDI REG16,0b11110000
  TST REG16
   BREQ OVERLAP_DEC_SET_SEC_TEN
    SUBI REG16,0b00010000
     JMP DEC_SET_SEC_TEN_SAVE

OVERLAP_DEC_SET_SEC_TEN:
 LDI REG16,0x50

DEC_SET_SEC_TEN_SAVE:
 ANDI REG17,0b00001111
  ADD REG16,REG17
   RET

DEC_3_9_T:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b00001111
   TST REG16
    BREQ OVERLAP_DEC_SET_HOUR_ONE
     DEC REG16
      JMP DEC_SET_HOUR_ONE_SAVE

OVERLAP_DEC_SET_HOUR_ONE:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b11110000
   CPI REG16,0x20
    BRSH HOURS_MAX_X3
     LDI REG16,0x09
      JMP DEC_SET_HOUR_ONE_SAVE

HOURS_MAX_X3:
 LDI REG16,0x03

DEC_SET_HOUR_ONE_SAVE:
 LDS REG17,TIME_BUFFER
  ANDI REG17,0b11110000
   ADD REG16,REG17
    STS TIME_BUFFER,REG16
     RET

DEC_2_T:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b11110000
   TST REG16
    BREQ OVERLAP_DEC_SET_HOUR_TEN
     SUBI REG16,0b00010000
      JMP DEC_SET_HOUR_TEN_SAVE

OVERLAP_DEC_SET_HOUR_TEN:
 LDS REG16,TIME_BUFFER
  ANDI REG16,0b00001111
   CPI REG16,0x04
    BRSH DEC_SET_HOUR_TEN_RESAVE
     LDI REG16,0x20

DEC_SET_HOUR_TEN_SAVE:
 LDS REG17,TIME_BUFFER
  ANDI REG17,0b00001111
   ADD REG16,REG17
    STS TIME_BUFFER,REG16
     JMP CLT_KEY

DEC_SET_HOUR_TEN_RESAVE:
 LDI REG16,0x23
  STS TIME_BUFFER,REG16
   RET

;-----------------------------------------------
;ֲ  ò     Y
;-----------------------------------------------
DATE_MENU_LOGIC_L:
 LDS REG16,MENU_Y
  CPI REG16,0
   BREQ DATE_MENU_LOGIC_STAGE_Y0_L
    CPI REG16,1
     BREQ DATE_MENU_LOGIC_STAGE_Y1_L
      CPI REG16,2
       BREQ DATE_MENU_LOGIC_STAGE_Y2_L
        CLR REG16
         STS MENU_Y,REG16
          RET

DATE_MENU_LOGIC_STAGE_Y0_L:
 CALL LOGIC_VECTOR_SUPERVISOR_LEVEL_Y0
  RET

DATE_MENU_LOGIC_STAGE_Y1_L:
 CALL LOGIC_VECTOR_SUPERVISOR_LEVEL_Y1
  RET

DATE_MENU_LOGIC_STAGE_Y2_L:
 LDS REG16,KEY_CODE
  CPI REG16,'R'
   BRNE DATE_SET_L
    LDS REG16,SUB_MENU_6
     CPI REG16,0
      BREQ INC_DATE_YEAR
       CPI REG16,1
        BREQ INC_DATE_YEAR
         CPI REG16,2
          BREQ INC_DATE_MONTH
           CPI REG16,3
            BREQ INC_DATE_MONTH
             CPI REG16,4
              BREQ INC_DATE_DAY
               CPI REG16,5
                BREQ INC_DATE_DAY
                 RET

INC_DATE_YEAR:
 JMP INC_DATE_Y

INC_DATE_MONTH:
 JMP INC_DATE_M

INC_DATE_DAY:
 JMP INC_DATE_D

DATE_SET_L:
 LDS REG16,KEY_CODE
  CPI REG16,'L'
   BRNE DATE_SET_C
    LDS REG16,SUB_MENU_6
     CPI REG16,0
      BREQ DEC_DATE_YEAR
       CPI REG16,1
        BREQ DEC_DATE_YEAR
         CPI REG16,2
          BREQ DEC_DATE_MONTH
           CPI REG16,3
            BREQ DEC_DATE_MONTH
             CPI REG16,4
              BREQ DEC_DATE_DAY
               CPI REG16,5
                BREQ DEC_DATE_DAY
                 RET

DEC_DATE_YEAR:
 JMP DEC_DATE_Y

DEC_DATE_MONTH:
 JMP DEC_DATE_M

DEC_DATE_DAY:
 JMP DEC_DATE_D

DATE_SET_C:
 JMP TMLSY2L_C
;------------------------------------------------
;__ֲ__
;------------------------------------------------
INC_DATE_Y:
 LDS REG16,D_YEAR
  MOV REG17,REG16
   CPI REG17,0x99
    BRSH DATE_Y_CLR
     ANDI REG17,0b00001111
      CPI REG17,0x09
       BRSH INC_AND_CLR
        INC REG17
         JMP SIMPLE_INC

INC_AND_CLR:
 LDI REG17,0x10

SIMPLE_INC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_YEAR,REG16
    JMP INC_DATE_Y_OUT

DATE_Y_CLR:
 CLR REG16
  STS D_YEAR,REG16

INC_DATE_Y_OUT:
 CALL DAY_LIMIT_COMPARE
  JMP CLT_KEY

INC_DATE_M:
 LDS REG16,D_MONTHS
  MOV REG17,REG16
   CPI REG17,0x12
    BRSH DATE_M_CLR
     ANDI REG17,0b00001111
      CPI REG17,0x09
       BRSH INC_M
        INC REG17
         JMP SIMPLE_M_INC

INC_M:
 LDI REG17,0x10

SIMPLE_M_INC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_MONTHS,REG16
    JMP INC_DATE_M_OUT

DATE_M_CLR:
 LDI REG16,1
  STS D_MONTHS,REG16

INC_DATE_M_OUT:
 CALL DAY_LIMIT_COMPARE
  JMP CLT_KEY

INC_DATE_D:
 CALL DAY_LIMIT_COMPARE
  LDS REG16,D_DAY
   MOV REG17,REG16
    LDS REG18,DATE_SET_LIMIT
     CP REG17,REG18
      BRSH DATE_D_CLR
       ANDI REG17,0b00001111
        CPI REG17,0x09
         BRSH INC_D
          INC REG17
           JMP SIMPLE_D_INC

INC_D:
 LDI REG17,0x10

SIMPLE_D_INC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_DAY,REG16
    JMP INC_DATE_D_OUT

DATE_D_CLR:
 LDI REG16,1
  STS D_DAY,REG16

INC_DATE_D_OUT:
 JMP CLT_KEY

DEC_DATE_Y:
 LDS REG16,D_YEAR
  MOV REG17,REG16
   CPI REG17,0x00
    BREQ DATE_Y_TOP
     ANDI REG17,0b00001111
      CPI REG17,0x00
       BREQ DEC_AND_CLR
        DEC REG17
         JMP SIMPLE_DEC

DEC_AND_CLR:
 LDI REG17,0x09
  SUBI REG16,0x10

SIMPLE_DEC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_YEAR,REG16
    JMP DEC_DATE_Y_OUT

DATE_Y_TOP:
 LDI REG16,0x99
  STS D_YEAR,REG16

DEC_DATE_Y_OUT:
 CALL DAY_LIMIT_COMPARE
  JMP CLT_KEY

DEC_DATE_M:
 LDS REG16,D_MONTHS
  MOV REG17,REG16
   CPI REG17,0x01
    BREQ DATE_M_TOP
     ANDI REG17,0b00001111
      CPI REG17,0x00
       BREQ DEC_M
        DEC REG17
         JMP SIMPLE_M_DEC

DEC_M:
 LDI REG17,0x09
  SUBI REG16,0x10

SIMPLE_M_DEC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_MONTHS,REG16
    JMP DEC_DATE_M_OUT

DATE_M_TOP:
 LDI REG16,0x12
  STS D_MONTHS,REG16

DEC_DATE_M_OUT:
 CALL DAY_LIMIT_COMPARE
  JMP CLT_KEY

DEC_DATE_D:
 CALL DAY_LIMIT_COMPARE
  LDS REG16,D_DAY
   MOV REG17,REG16
    CPI REG17,0x01
     BREQ DATE_D_TOP
      ANDI REG17,0b00001111
       CPI REG17,0x00
        BREQ DEC_D
         DEC REG17
          JMP SIMPLE_D_DEC

DEC_D:
 LDI REG17,0x09
  SUBI REG16,0x10

SIMPLE_D_DEC:
 ANDI REG16,0b11110000
  ADD REG16,REG17
   STS D_DAY,REG16
    JMP DEC_DATE_D_OUT

DATE_D_TOP:
 LDS REG16,DATE_SET_LIMIT
  STS D_DAY,REG16

DEC_DATE_D_OUT:
 JMP CLT_KEY

DAY_LIMIT_COMPARE:
 LDS REG16,D_MONTHS
  ANDI REG16,0b01111111
   CPI REG16,0x02
    BREQ DAY_4_Y
     CPI REG16,0x04
      BREQ DAY_30
       CPI REG16,0x06
        BREQ DAY_30
         CPI REG16,0x09
          BREQ DAY_30
           CPI REG16,0x11
            BREQ DAY_30
             LDI REG16,0x31
              STS DATE_SET_LIMIT,REG16
               JMP DAY_LIMIT_OUT

DAY_30:
 LDI REG16,0x30
  STS DATE_SET_LIMIT,REG16
   JMP DAY_LIMIT_OUT

DAY_4_Y:
 LDS REG16,D_YEAR
  CPI REG16,0x00
   BREQ DAY_29
    CPI REG16,0x04
     BREQ DAY_29
      CPI REG16,0x08
       BREQ DAY_29
        CPI REG16,0x12
         BREQ DAY_29
          CPI REG16,0x16
           BREQ DAY_29
            CPI REG16,0x20
             BREQ DAY_29
              CPI REG16,0x24
               BREQ DAY_29
                CPI REG16,0x28
                 BREQ DAY_29
                  CPI REG16,0x32
                   BREQ DAY_29
                    CPI REG16,0x36
                     BREQ DAY_29
                      CPI REG16,0x40
                       BREQ DAY_29
                        CPI REG16,0x44
                         BREQ DAY_29
                          CPI REG16,0x48
                           BREQ DAY_29
                            CPI REG16,0x52
                             BREQ DAY_29
                              CPI REG16,0x56
                               BREQ DAY_29
                                CPI REG16,0x60
                                 BREQ DAY_29
                                  CPI REG16,0x64
                                   BREQ DAY_29
                                    CPI REG16,0x68
                                     BREQ DAY_29
                                      CPI REG16,0x72
                                       BREQ DAY_29
                                        CPI REG16,0x76
                                         BREQ DAY_29
                                          CPI REG16,0x80
                                           BREQ DAY_29
                                            CPI REG16,0x84
                                             BREQ DAY_29
                                              CPI REG16,0x88
                                               BREQ DAY_29
                                                CPI REG16,0x92
                                                 BREQ DAY_29
                                                  CPI REG16,0x96
                                                   BREQ DAY_29

DAY_28:
 LDI REG16,0x28
  STS DATE_SET_LIMIT,REG16
   JMP DAY_LIMIT_OUT

DAY_29:
 LDI REG16,0x29
  STS DATE_SET_LIMIT,REG16

DAY_LIMIT_OUT:
 LDS REG17,D_DAY
  CP REG17,REG16
   BRSH GET_TOP_DAY

JUST_OUT:
 RET

GET_TOP_DAY:
 LDS REG16,DATE_SET_LIMIT
  STS D_DAY,REG16
   RET

;-----------------------------------------------
;ֲ  ò     Y
;-----------------------------------------------
TEMPERATURE_MENU_LOGIC_L: ;ֲ    вͲ -0  -1
 LDS REG16,MENU_Y
  CPI REG16,0
   BREQ TEMPERATURE_MENU_LOGIC_STAGE_Y0
    CPI REG16,1
     BREQ TEMPERATURE_MENU_LOGIC_STAGE_Y1
      CLR REG16
       STS MENU_Y,REG16
        RET

TEMPERATURE_MENU_LOGIC_STAGE_Y0: ;в -0  
 CALL LOGIC_VECTOR_SUPERVISOR_LEVEL_Y0
  RET

TEMPERATURE_MENU_LOGIC_STAGE_Y1: ;в -1   Ҳ  
 LDS REG16,KEY_CODE
  CPI REG16,'L'
   BRNE SET_T_R
    CALL DECREMENT_TIC_SPEED
     CALL HOLD_CLR
      RET

SET_T_R:
 CPI REG16,'R'
  BRNE SET_T_C
   CALL INCREMENT_TIC_SPEED
    CALL HOLD_CLR
     RET

SET_T_C:
 CALL OK_HOLD
  CLR REG16
   STS OK_FLIP,REG16

INTERNAL_LOGIC_OUT:
 RET
;-----------------------------------------------
;ֲ  ò ̲   
;-----------------------------------------------
DECREMENT_TIC_SPEED: ;ֲ   Ҳ  
 LDS REG16,AGING_OFFSET
  MOV REG17,REG16
   ANDI REG17,0b10000000
    CPI REG17,0b10000000
     BREQ MINUS_AGING
      TST REG16
       BREQ DEC_ZERO
        DEC REG16
         STS AGING_OFFSET,REG16
          JMP DECREMENT_AGING_OUT

DEC_ZERO:
 LDI REG16,0b10000001
  STS AGING_OFFSET,REG16
   JMP DECREMENT_AGING_OUT

MINUS_AGING:
 ANDI REG16,0b01111111
  CPI REG16,99
   BRSH DECREMENT_AGING_OUT
    INC REG16
     LDI REG17,0b10000000
      ADD REG16,REG17
       STS AGING_OFFSET,REG16

DECREMENT_AGING_OUT:
 CLR REG16
  STS KEY_CODE,REG16
   RET

INCREMENT_TIC_SPEED: ;ֲ   Ҳ  
 LDS REG16,AGING_OFFSET
  MOV REG17,REG16
   ANDI REG17,0b10000000
    CPI REG17,0b10000000
     BREQ PLUS_AGING
      CPI REG16,99
       BRSH INCREMENT_AGING_OUT
        INC REG16
         STS AGING_OFFSET,REG16
          JMP INCREMENT_AGING_OUT

INC_ZERO:
 CLR REG16
  STS AGING_OFFSET,REG16
   JMP INCREMENT_AGING_OUT

PLUS_AGING:
 CPI REG16,0b10000001
  BREQ INC_ZERO
   ANDI REG16,0b01111111
    DEC REG16
     LDI REG17,0b10000000
      ADD REG16,REG17
       STS AGING_OFFSET,REG16

INCREMENT_AGING_OUT:
 CLR REG16
  STS KEY_CODE,REG16
   RET

;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;SAVE_SET_TIME_TO_DS3231
;----------------------------------------------
DISPLAY_SEGMENT_DECODER:
 MOV REG16,XregL
  ANDI XregL,0b00001111
   STS SEG_ELEMENT_0,XregL
    ANDI REG16,0b11110000
     SWAP REG16
      STS SEG_ELEMENT_1,REG16
        MOV REG17,XregH
         ANDI XregH,0b00001111
          STS SEG_ELEMENT_2,XregH
           ANDI REG17,0b11110000
            SWAP REG17
             STS SEG_ELEMENT_3,REG17

TIME_MENU_OUT:
 CALL INTERNAL_LOGIC
  CALL SEG_DOTS_SET_INDICATE

RET

;-----------------------------------------------
;I2C_MASTER_TYPE--------
;-----------------------------------------------
;- I2C_INIT,START,SEND,GET,ASK,NACK,RESTART,STOP
;- R16,17,18,XL 
;-        
;- XL    
;- I2C SDA, PA6
;- I2C SCL, PA7
I2C_START:
 SBI DDRA,6
  CALL I2C_WAIT
   SBI DDRA,7
    CALL I2C_WAIT
     RET

I2C_STOP:
 SBI DDRA,6
  CALL I2C_WAIT
   CBI DDRA,7
    CALL I2C_WAIT
     CBI DDRA,6
      CALL I2C_WAIT
       RET

I2C_RESTART:
 CBI DDRA,6
  CALL I2C_WAIT
   CBI DDRA,7
    CALL I2C_WAIT
     CALL I2C_START
      RET

I2C_ACK:
 SBI DDRA,6
  CALL I2C_WAIT
   CALL BLINK
    RET

I2C_NACK:
 CBI DDRA,6

BLINK:
 CALL I2C_WAIT
  CBI DDRA,7
   CALL I2C_WAIT
    SBI DDRA,7
     CALL I2C_WAIT
      RET

I2C_GET:
 CBI DDRA,6
  CLR R16
   CLR XL
    LDI R18,8
     JMP I2C_BYTE_READ_ONE

I2C_BYTE_READ_ZERO:
 CPI R18,0
  BREQ I2C_BYTE_READ_OUT
   LSL XL

I2C_BYTE_READ_ONE:
 DEC R18
  CBI DDRA,7
   CALL I2C_WAIT
    IN R16,PINA
     SBI DDRA,7
      CALL I2C_WAIT
       ANDI R16,0b01000000
        CALL I2C_WAIT
         CPI R16,0b01000000
          BRNE I2C_BYTE_READ_ZERO

I2C_READ_BYTE_ONE:
 INC XL
  JMP I2C_BYTE_READ_ZERO

I2C_BYTE_READ_OUT:
 RET

I2C_SEND:
 LDI R16,0b00100000
  STS I2C_DEVICE_ERR,R16
   LDI R18,8

I2C_SEND0:
 CPI R18,0
  BREQ READ_ACK
   DEC R18
    LSL XL
     BRCS SEND_ONE_B

SEND_ZERO_B:
 SBI DDRA,6
  CALL I2C_WAIT
   CBI DDRA,7
    CALL I2C_WAIT
     SBI DDRA,7
      CALL I2C_WAIT
       JMP I2C_SEND0

SEND_ONE_B:
 CBI DDRA,6
  CALL I2C_WAIT
   CBI DDRA,7
    CALL I2C_WAIT
     SBI DDRA,7
      CALL I2C_WAIT
       JMP I2C_SEND0

READ_ACK:
 CBI DDRA,6
  CALL I2C_WAIT
   CBI DDRA,7
    CALL I2C_WAIT
     IN R16,PINC
      ANDI R16,0b00010000
       CPI R16,0b00010000
        BRNE BYTE_END

FAIL:
 LDI R16,'E'
  STS I2C_DEVICE_ERR,R16

BYTE_END:
 SBI DDRA,7
  CALL I2C_WAIT

RET

I2C_WAIT:
 LDI R17,10

I2W:
 DEC R17
  BRNE I2W
   RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;REGISTERS_UPDATE_FROM_DS3231_VIA_I2C
;----------------------------------------------
I2C_READ_CHECK:
 LDS REG16,I2C_CHECK_NEED_FLAG
  SBRC REG16,0
   CALL I2C_TIME_PROC_READ
    RET

I2C_TIME_PROC_READ:
 CALL I2C_START
  LDI XL,0b11010000
   CALL I2C_SEND
    LDI XL,0x00
     CALL I2C_SEND
      CALL I2C_RESTART
       LDI XL,0b11010001
        CALL I2C_SEND
         CALL I2C_GET
          STS T_SECONDS,XL
           CALL I2C_ACK
            CALL I2C_GET
             STS T_MINUTES,XL
              CALL I2C_ACK
               CALL I2C_GET
                STS T_HOURS,XL
                 CALL I2C_ACK
                  CALL I2C_GET
                   STS D_WEEK_DAY,XL
                    CALL I2C_ACK
                     CALL I2C_GET
                      STS D_DAY,XL
                       CALL I2C_ACK
                        CALL I2C_GET
                         STS D_MONTHS,XL
                          CALL I2C_ACK
                           CALL I2C_GET
                            STS D_YEAR,XL
                             CALL I2C_NACK
                              CALL I2C_RESTART
                               LDI XL,0b11010000
                                CALL I2C_SEND
                                 LDI XL,0x10
                                  CALL I2C_SEND
                                   CALL I2C_RESTART
                                    LDI XL,0b11010001
                                     CALL I2C_SEND
                                      CALL I2C_GET
                                       STS AGING_OFFSET,XL
                                        CALL I2C_ACK
                                         CALL I2C_GET
                                          STS S_TEMPERATURE,XL
                                           CALL I2C_NACK
                                            CALL I2C_STOP
                                             CLR REG16
                                              STS I2C_CHECK_NEED_FLAG,REG16
                                               RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;SAVE_SET_TIME_TO_DS3231
;----------------------------------------------
I2C_SAVE_TIME_TO_DS3231:
 CALL I2C_START
  LDI XL,0b11010000
   CALL I2C_SEND
    LDI XL,0x00
     CALL I2C_SEND
      LDS XL,T_SECONDS
       CALL I2C_SEND
        LDS XL,T_MINUTES
         CALL I2C_SEND
          LDS XL,T_HOURS
           CALL I2C_SEND
            CALL I2C_STOP
             RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;SAVE_SET_DATE_TO_DS3231
;----------------------------------------------
I2C_SAVE_DATE_TO_DS3231:
 CALL I2C_START
  LDI XL,0b11010000
   CALL I2C_SEND
    LDI XL,0x04
     CALL I2C_SEND
      LDS XL,D_DAY
       CALL I2C_SEND
        LDS XL,D_MONTHS
         CALL I2C_SEND
          LDS XL,D_YEAR
           CALL I2C_SEND
            CALL I2C_STOP
             RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;I2C_SAVE_AGING_TO_DS3231
;----------------------------------------------
I2C_SAVE_AGING_TO_DS3231:
 CALL I2C_START
  LDI XL,0b11010000
   CALL I2C_SEND
    LDI XL,0x10
     CALL I2C_SEND
      LDS XL,AGING_OFFSET
       CALL I2C_SEND
        CALL I2C_STOP
         RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;----KEYBOARD_PROC------
;----------------------------------------------
;KEY_CODE: .byte 1
;KEY_PUSH_DETECT: .byte 1
;KEY_TIME_T_TRIGGER: .byte 1
;KEY_DUBLED: .byte 1
KEYBOARD_PORTx:                      ;PB0 - LEFT,PB3 - RIGHT,PB4 - CENTRAL
 LDS REG16,KEY_PUSH_DETECT
  CPI REG16,'P'
   BRNE MONITOR_KEY_PUSH

MONITOR_KEY_UNPUSH:
 IN REG16,PINB                       ;    
  ANDI REG16,0b00010011              ;      
   CPI REG16,0b00010011
    BRNE KEY_UNP
     LDS REG17,KEY_TIME_T_TRIGGER
      DEC REG17
       STS KEY_TIME_T_TRIGGER,REG17
        CPI REG17,0
         BREQ BUTTON_WAS_UNPRESSED
          JMP KEYBOARD_PORTx_OUT    ;  

MONITOR_KEY_PUSH:
 IN REG16,PINB                       ;    
  ANDI REG16,0b00010011              ;  ,     

START_TO_CHECK:
 LDS REG17,KEY_DUBLED
  CP REG16,REG17
   BRNE COPY_MASK
    MOV REG19,REG16
     CLR R17
      LDI R18,9

CHECK_MULTIPLE_PUSH:
 DEC R18
  CPI R18,0
   BREQ CHECK_MULTIPLE_PUSH_END
    LSL REG19
     BRCS CHECK_MULTIPLE_PUSH
      INC R17
       JMP CHECK_MULTIPLE_PUSH

CHECK_MULTIPLE_PUSH_END:             ; ,     1 
 CPI R17,7                           ;ʳ  ,    0,  =ANDIzeroBits+2 
  BRSH KEYBOARD_MULTIPLE_PUSH        ;  

 SBRS REG16,0
 JMP BUTTON_1                       ;LEFT

 SBRS REG16,1
 JMP BUTTON_2                       ;CENTRAL

;SBRS REG16,2
;JMP BUTTON_3                       ;  ,  

;SBRS REG16,3
;JMP BUTTON_4

 SBRS REG16,4
 JMP BUTTON_5                       ;RIGHT

;SBRS REG16,5
;JMP BUTTON_6

;SBRS REG16,6
;JMP BUTTON_7

;SBRS REG16,7
;JMP BUTTON_8

 LDI REG16,'N'
 STS KEY_CODE,REG16

 JMP KEYBOARD_PORTx_OUT             ;  

BUTTON_WAS_UNPRESSED:
 LDI REG16,'U'
  STS KEY_PUSH_DETECT,REG16
   LDI REG16,'N'
    STS KEY_CODE,REG16
     JMP KEY_UNP
;---------------------------
COPY_MASK:
 STS KEY_DUBLED,REG16

KEY_UNP:
 LDI REG16,250
  STS KEY_TIME_T_TRIGGER,REG16       ; 
   JMP KEYBOARD_PORTx_OUT           ;  
;---------------------------
BUTTON_1:
 LDI REG16,'L'
  JMP SET_PUSH_FLAG
;---------------------------         ; 
BUTTON_2:
 LDI REG16,'C'
  JMP SET_PUSH_FLAG
;---------------------------
;BUTTON_3:
; LDI REG16,'3'
;  JMP SET_PUSH_FLAG
;---------------------------
;BUTTON_4:
; LDI REG16,'R'
;  JMP SET_PUSH_FLAG
;---------------------------
BUTTON_5:
 LDI REG16,'R'
  JMP SET_PUSH_FLAG
;---------------------------
;BUTTON_6:
; LDI REG16,'6'
;  JMP SET_PUSH_FLAG
;---------------------------
;BUTTON_7:
; LDI REG16,'7'
;  JMP SET_PUSH_FLAG
;---------------------------
;BUTTON_8:
; LDI REG16,'8'
;  JMP SET_PUSH_FLAG
;---------------------------
KEYBOARD_MULTIPLE_PUSH:
 LDI REG16,'M'

SET_PUSH_FLAG:
 LDS REG17,KEY_TIME_T_TRIGGER
  DEC REG17
   STS KEY_TIME_T_TRIGGER,REG17
    CPI REG17,0
     BRNE KEYBOARD_PORTx_OUT         ;  

BUTTON_WAS_PRESSED:
 STS KEY_CODE,REG16
  LDI REG16,'P'
   STS KEY_PUSH_DETECT,REG16

KEYBOARD_PORTx_OUT:                  ;  
 RET
;----------------------------------------------
;------PROC_END---------
;-----------------------

;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;--------------------------------------INTERRUPT_MODULES---------------------
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------

;-----------------------
;TIMER1_COMP_A_INTERRUPT_PROCEDURE
;--------------------------------------
TIMER1_COMP_A:
 PUSH REG16
  IN REG16,SREG
   PUSH REG16
    LDI REG16,1
     STS IN_SYSTEM_CLOCK,REG16
      POP REG16
       OUT SREG,REG16
        POP REG16

RETI
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;INT_0_INTERRUPT_PROCEDURE
;--------------------------------------
INT_0:;RTC_INT
 PUSH REG16
  IN REG16,SREG
   PUSH REG16
    LDI REG16,1
     STS I2C_CHECK_NEED_FLAG,REG16
      LDS REG16,MENU_X
       TST REG16
        BRNE CLR_DOT
         LDS REG16,MENU_Y
          TST REG16
           BRNE CLR_DOT
            TST REG21
             BRNE JUMP_OUT_DOT
              TST REG22
               BREQ CLR_DOT

SET_C_DOT:
 LDI REG16,1
  STS CENTRAL_DOT_ACTIVATE,REG16
   LDI REG16,220
    OUT OCR0,REG16
     JMP RENEW_FLAG

CLR_DOT:
 CLR REG16
  STS CENTRAL_DOT_ACTIVATE,REG16
   LDI REG16,200
    OUT OCR0,REG16

RENEW_FLAG:
 LDI REG21,1
  COM REG22
   ANDI REG22,0b00000001

JUMP_OUT_DOT:
 LDS REG16,HALT_FLIP_REG
  CPI REG16,10
   BREQ NO_NEED
    INC REG16
     STS HALT_FLIP_REG,REG16

NO_NEED:
  DEC REG21
   POP REG16
    OUT SREG,REG16
     POP REG16

RETI
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;ADC_10_BIT_INTERRUPT_PROCEDURE
;--------------------------------------
ADC_10_BIT:
 PUSH REG16
  IN REG16,SREG
   PUSH REG16
    PUSH REG17
     PUSH XregL
      PUSH XregH
       IN REG16,ADCL
        IN REG17,ADCH
         SUBI REG16,0b00011000;0b00111001
          SBCI REG17,0b00000011;0b00000011
		   BRMI ADC_CLR
            JMP ADC_OUT

ADC_CLR:
 CLR REG16

ADC_OUT:
 STS ADC_BAT_VALUE_TEMP,REG16
  LDI REG17,1
    STS ADC_VAL_FLIP,REG17
     POP XregH
      POP XregL
       POP REG17
        POP REG16
         OUT SREG,REG16
          POP REG16

RETI

;-----------------------
;TIMER2_INTERRUPT_PROCEDURE
;--------------------------------------
TIMER2_COMP:;DISPLAY_DRIVER
 PUSH REG16
  IN REG16,SREG
   PUSH REG16
    PUSH REG17
     PUSH XregL
      PUSH XregH
       LDS REG16,SEG_ACT_FLAG
        SBRC REG16,0
         JMP SYMB_OUTPUT_OUT

SYMB_OUTPUT:
 CLR REG17
  LDS REG16,SEGMENT_STEP
   LDI ZregL,LOW(SEG_ELEMENT_0)
    LDI ZregH,HIGH(SEG_ELEMENT_0)
     ADD ZregL,REG16 
      ADC ZregH,REG17
       LD REG16,Z
        LDI REG17,1
         STS SEG_ACT_FLAG,REG17

SEG_TABLE_DECODER:
 CPI REG16,0
  BRNE SYMB_1
   SBI PORTD,4
    JMP SYMB_OUTPUT_OUT

SYMB_1:
 CPI REG16,1
  BRNE SYMB_2
   SBI PORTD,5
    JMP SYMB_OUTPUT_OUT

SYMB_2:
 CPI REG16,2
  BRNE SYMB_3
   SBI PORTD,6
    JMP SYMB_OUTPUT_OUT

SYMB_3:
 CPI REG16,3
  BRNE SYMB_4
   SBI PORTC,5
    JMP SYMB_OUTPUT_OUT

SYMB_4:
 CPI REG16,4
  BRNE SYMB_5
   SBI PORTC,4
    JMP SYMB_OUTPUT_OUT

SYMB_5:
 CPI REG16,5
  BRNE SYMB_6
   SBI PORTC,2
    JMP SYMB_OUTPUT_OUT

SYMB_6:
 CPI REG16,6
  BRNE SYMB_7
   SBI PORTC,1
    JMP SYMB_OUTPUT_OUT

SYMB_7:
 CPI REG16,7
  BRNE SYMB_8
   SBI PORTC,3
    JMP SYMB_OUTPUT_OUT

SYMB_8:
 CPI REG16,8
  BRNE SYMB_9
   SBI PORTC,0
    JMP SYMB_OUTPUT_OUT

SYMB_9:
 CPI REG16,9
  BRNE SYMB_NONE
   SBI PORTD,1
    JMP SYMB_OUTPUT_OUT

SYMB_NONE:
 CALL SEGMENT_CLR

SYMB_OUTPUT_OUT:
 LDS REG16,TIME_SEGMENT
  TST REG16
   BREQ CHANGE_SEGMENT
    DEC REG16
     STS TIME_SEGMENT,REG16

CHK_ON_NEED:
 LDS REG17,SEG_PWM_PERIOD_TEMP_START
  CP REG17,REG16
   BRNE CHK_OFF_NEED
    CALL LAMP_SET
     JMP GRAPHIC_OUT

CHK_OFF_NEED:
 LDS REG17,SEG_PWM_PERIOD_TEMP_END
  CP REG17,REG16
   BRNE GRAPHIC_OUT 
    CALL LAMP_CLR
     JMP GRAPHIC_OUT

CHANGE_SEGMENT:
 LDS REG16,SEGMENT_STEP
  INC REG16
   CPI REG16,4
    BRNE SAVE_SEG_CHANGE
     CLR REG16

SAVE_SEG_CHANGE:
 STS SEGMENT_STEP,REG16
  CLR REG17
   STS SEG_ACT_FLAG,REG17
    LDI ZregL,LOW(SEG_01_PWM_PERIOD)
     LDI ZregH,HIGH(SEG_01_PWM_PERIOD)
      ADD ZregL,REG16 
       ADC ZregH,REG17
        LD REG16,Z
         LDI REG17,50
          STS TIME_SEGMENT,REG17
           SUB REG17,REG16
            LSR REG17
             STS SEG_PWM_PERIOD_TEMP_END,REG17
              LDI REG16,50
               SUB REG16,REG17
                STS SEG_PWM_PERIOD_TEMP_START,REG16
                 CALL SEGMENT_CLR
                  CALL LAMP_CLR

GRAPHIC_OUT:
 LDS REG16,CENTRAL_DOT_ACTIVATE
  TST REG16
   BREQ CENTRAL_DOT_OFF
    SBI PORTA,0
     JMP CENTRAL_DOT_ON

CENTRAL_DOT_OFF:
 CBI PORTA,0

CENTRAL_DOT_ON:
 CALL PWM_CHNG
  POP XregH
   POP XregL
    POP REG17
     POP REG16
      OUT SREG,REG16
       POP REG16

RETI

PWM_CHNG:
 CLC
  LDS REG16,PWM_CHNG_GENERATOR
   LDI REG17,1
    ADD REG16,REG17
     BRCS PWM_MATCH
      STS PWM_CHNG_GENERATOR,REG16
       JMP PWM_OUT

PWM_MATCH:
 STS PWM_CHNG_GENERATOR,REG16
  LDS REG16,BLINK_AUTO_OFF
   TST REG16
    BREQ PWM_NEXT
     LDS REG16,BLINK_AUTO_OFF_TIME
      TST REG16
       BREQ CLR_PWM
        DEC REG16
         STS BLINK_AUTO_OFF_TIME,REG16

PWM_NEXT:
  LDS REG16,PWM_CHNG_FLAG
   TST REG16
    BREQ PWM_DECREMENT
     LDS REG16,PWM_CHNG_BUFFER
      CPI REG16,48
       BREQ CNHG_DOWN
        INC REG16
         STS PWM_CHNG_BUFFER,REG16
          JMP PWM_OUT

CNHG_DOWN:
 CLR REG16
  STS PWM_CHNG_FLAG,REG16
   JMP PWM_OUT

PWM_DECREMENT:
 LDS REG16,PWM_CHNG_BUFFER
  CPI REG16,1
   BREQ CNHG_UP
    DEC REG16
     STS PWM_CHNG_BUFFER,REG16
      JMP PWM_OUT

CNHG_UP:
 LDI REG16,1
  STS PWM_CHNG_FLAG,REG16

PWM_OUT:
 LDS REG16,BLINK_START
  TST REG16
   BREQ CLR_PWM
    LDS REG17,PWM_CHNG_BUFFER
     LDS REG16,BLINK_SEG
      SBRS REG16,0
       JMP P_SEG_2
        STS SEG_01_PWM_PERIOD,REG17

P_SEG_2:
 SBRS REG16,1
  JMP P_SEG_3
   STS SEG_02_PWM_PERIOD,REG17

P_SEG_3:
 SBRS REG16,2
  JMP P_SEG_4
   STS SEG_03_PWM_PERIOD,REG17

P_SEG_4:
 SBRS REG16,3
  JMP PWM_OUT_D
   STS SEG_04_PWM_PERIOD,REG17

PWM_OUT_D:

RET

CLR_PWM:
 LDI REG16,48;  
  STS SEG_01_PWM_PERIOD,REG16
   STS SEG_02_PWM_PERIOD,REG16
    STS SEG_03_PWM_PERIOD,REG16
     STS SEG_04_PWM_PERIOD,REG16
      STS PWM_CHNG_BUFFER,REG16
       LDI REG16,0xFF
        STS BLINK_AUTO_OFF_TIME,REG16
         CLR REG16
          STS BLINK_START,REG16
           STS BLINK_AUTO_OFF,REG16
            JMP PWM_OUT_D

SEGMENT_CLR:
 CBI PORTD,4
  CBI PORTD,5
   CBI PORTD,6
    CBI PORTC,5
     CBI PORTC,4
      CBI PORTC,2
       CBI PORTC,1
        CBI PORTC,3
         CBI PORTC,0
          CBI PORTD,1
           CBI PORTD,0

RET

LAMP_CLR:
 CBI PORTA,4
  CBI PORTA,5
   CBI PORTC,7
    CBI PORTC,6

RET

LAMP_SET:
 LDS REG16,SEGMENT_STEP
  CPI REG16,0
   BRNE SEG_2
    SBI PORTC,6
     JMP SEG_ACT_OUT

SEG_2:
 CPI REG16,1
  BRNE SEG_3
   SBI PORTC,7
    JMP SEG_ACT_OUT

SEG_3:
 CPI REG16,2
  BRNE SEG_4
   SBI PORTA,5
    JMP SEG_ACT_OUT

SEG_4:
 CPI REG16,3
  BRNE SEG_ACT_OUT
   SBI PORTA,4

SEG_ACT_OUT:

RET
;--------------------------------------
;------PROC_END---------
;-----------------------

;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;--------------------------------------INIT_MODULES--------------------------
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------

;-----------------------
;DS3231_INIT_VIA_I2C----
;--------------------------------------
I2C_DS3231_START_INIT:
 CALL I2C_START
  LDI XL,0b11010000
   CALL I2C_SEND
    LDI XL,0x0E
     CALL I2C_SEND
      LDI XL,0x00
       CALL I2C_SEND
        LDI XL,0x00
         CALL I2C_SEND
          CALL I2C_STOP
           RET
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;PWM_INIT_PRICEDURE-----
;--------------------------------------
PWM_ON:                         ;
 LDS REG16,ADC_BAT_RES          ;
  TST REG16                     ;
   BREQ PWM_OFF;LOW_BAT         ;
    CLR REG16                   ;
     STS PWR_DOWN_BAT_LOW,REG16 ;
      OUT TCNT0,REG16           ;
       LDI REG16,200            ;
        OUT OCR0,REG16          ;
         LDI REG16,0b01101001   ;
          OUT TCCR0,REG16       ;
           LDI REG16,1          ;
            STS PWM_STATUS,REG16;
                                ;
RET                             ;
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;PWM_DEINIT_PRICEDURE---
;--------------------------------------
PWM_OFF:                         ;
 LDI REG16,1                     ;
  STS PWR_DOWN_BAT_LOW,REG16     ;
   CLR REG16                     ;
    OUT TCCR0,REG16              ;
     CBI PORTB,3                 ;
      CLR REG16                  ;
       STS PWM_STATUS,REG16      ;
        STS OFF_BLOCK_FLAG,REG16 ;
                                 ;
RET                              ;
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;ADC_INIT_PROCEDURE
;--------------------------------------
ADC_INIT:
 SBI PORTA,1
  LDI REG16,0b00000011
   OUT ADMUX,REG16
    LDI REG16,0b11001111
     OUT ADCSRA,REG16

RET
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;ADC_DEINIT_PROCEDURE
;--------------------------------------
ADC_DEINIT:
 CLR REG16
  OUT ADCSRA,REG16
   CBI PORTA,1

RET
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;INTERRUPTS_INIT_PROCEDURE
;--------------------------------------
INTERRUPT_INIT:
 LDI REG16,0b11100010
  OUT MCUCR,REG16
   LDI REG16,0b01000000
    OUT MCUCSR,REG16
     LDI REG16,0b01000000
      OUT GICR,REG16

RET
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;TIMER_INIT_PROCEDURE
;--------------------------------------
TIMER_INIT_1:
 CLR REG16
  OUT TCNT1H,REG16
   OUT TCNT1L,REG16
    OUT TCCR1A,REG16
     LDI REG16,0b00001100
      OUT TCCR1B,REG16
       LDI REG16,0x7A ;0.2SEC 5HERTZ  ;0x7A 1SEC 1HERTZ
        OUT OCR1AH,REG16
         LDI REG16,0x12 ;0.2SEC 5HERTZ   ;0x12 1SEC 1HERTZ
          OUT OCR1AL,REG16

RET

TIMER_DEINIT_1:
 CLR REG16
  STS TCCR1B,REG16

RET
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;PWM_INIT_PROCEDURE
;--------------------------------------
TIMER_INIT_2:
 CLR REG16
  OUT TCNT2,REG16
   LDI REG16,0x2A;0x2A 24000;0x54;12000 HERTZ
    OUT OCR2,REG16
     LDI REG16,0b00001010
      OUT TCCR2,REG16
       LDI REG16,0b10011000
        OUT TIMSK,REG16

RET

TIMER_DEINIT_2:
 CLR REG16
  OUT TCCR2,REG16

RET
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;PORT_INIT_PRICEDURE----
;--------------------------------------
PORTS_INIT:                 ;
 LDI REG16,0b00110111       ;
  OUT DDRA,REG16            ;
   LDI REG16,0b00001000     ;
    OUT DDRB,REG16          ;
     LDI REG16,0b11111111   ;
      OUT DDRC,REG16        ;
       LDI REG16,0b01110011 ;
        OUT DDRD,REG16      ;
                            ;
RET                         ;
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;FULL_DEINIT----
;--------------------------------------
DEINIT_ALL:
 CALL PWM_OFF
  CLR REG16
   OUT DDRA,REG16
    OUT DDRB,REG16
     OUT DDRC,REG16
      OUT DDRD,REG16
       CALL TIMER_DEINIT_2
        CALL TIMER_DEINIT_1
         CALL ADC_DEINIT
          LDI REG16,0b11100000
           OUT GICR,REG16

RET
;--------------------------------------
;------PROC_END---------
;-----------------------

;-----------------------
;PRICEDURE_FOR_RAM_CLEARING
;--------------------------------------
CLR_MEM:                         ;
 LDI REG16,0                     ;DATA BYTE THAT WILL WRITE HIMSELF ON EACH RAM CELL FROM ZL TO XL
  LDI ZregL,low(START_BYTE)      ;LOW ADDRES BYTE OF CLEARING START VARIABLE 
   LDI ZregH,high(START_BYTE)    ;HIGH ADDRES BYTE OF CLEARING START VARIABLE 
    LDI XregL,low(END_BYTE+1)    ;LOW ADDRES BYTE OF CLEARING END VARIABLE
     LDI XregH,high(END_BYTE+1)  ;HIGH ADDRES BYTE OF CLEARING END VARIABLE
                                 ;
MEM_CLR_LOOP:                    ; <-* 
 ST Z+,REG16                     ;   |
  CP ZregL,XregL                 ;   | CLEAR LOOP-PROCEDURE
   CPC ZregH,XregH               ;   |
    BRLO MEM_CLR_LOOP            ;->-*
     RET                         ;
;--------------------------------------
;------PROC_END---------
;-----------------------

/*
;NIXIE_WATCH_PINOUT
;--------------------------------------
INVERTOR
PB3 - INVERTOR CONTROL PIN (1 - INVERTOR ON, 0 - INVERTOR OFF)
;--------------------------------------
SEGMENTS TRIGERS

PD0 - SEGMENTS_DOT

PA0 - CENTRAL_DOT

PA4 - 3D LAMP - HOURS TENS
PA5 - 2ND LAMP - HOURS SINGLE
PC7 - 1ST LAMP - MINUTES TENS
PC6 - 0 LAMP - MINUTES SINGLE

SYMBOLS
PD4 - 0
PD5 - 1
PD6 - 2
PC5 - 3
PC4 - 4
PC2 - 5
PC1 - 6
PC3 - 7
PC0 - 8
PD1 - 9
;--------------------------------------
USB_SCAN_LINE

PB2 - MAIN_SUPPLY CONTROL PIN(INT2)
;--------------------------------------
BUTTONS

PB4 - RIGHT BUTTON (0V - BUTTON PUSH)

PB0 - LEFT BUTTON (0V - BUTTON PUSH)

PB1 - CENTRAL BUTTON (0V - BUTTON PUSH)
;--------------------------------------
INTERNAL_Li-Ion_SCAN

PA3 (ADC3) - Li-Ion CHARGE SCAN PIN
;--------------------------------------
I2C RTC LINES

PA6 SDA (HiZ - 1, LOG 0 - 0)
PA7 SCL (HiZ - 1, LOG 0 - 0)

PD2 (INT0) - RTC INT
;--------------------------------------
PA2 - BUZZER PIN (5V ACTIVE)
;--------------------------------------
PA1 - AREF SIGNAL ON (5V ACTIVE)
;--------------------------------------
*/
